<?php
namespace TheplusAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit;

class TPAE_Widget_Promotion extends Widget_Base {
    protected $data = [];

    public function __construct($data = []) {
        parent::__construct([]);
        $this->data = $data;
    }

    public function get_name() {
        return $this->data['name'] ?? 'promo-widget';
    }
    public function get_title() {
        return $this->data['title'] ?? __('Pro Widget', 'tpebl');
    }
    public function get_icon() {
        return $this->data['icon'] ?? 'eicon-star';
    }
    public function get_categories() {
        return $this->data['categories'] ?? [ 'plus-essential' ];
    }

    // protected function render() {
    // }
    
    // public function render() {
    //     echo "This is the Pro widget of the Plus Addons";
    // }
}

// Enqueue CSS/JS for Elementor editor only
// add_action('elementor/editor/after_enqueue_styles', function () {
//     wp_enqueue_style(
//         'tp-widget-promotion',
//         L_THEPLUS_URL . 'modules/widget-promotion/tp-widget-popup.css',
//         array(),
//         L_THEPLUS_VERSION
//     );
// });

add_action('elementor/editor/after_enqueue_scripts', function () use ($tpae_promo_widgets) {
    wp_enqueue_script(
        'tp-widget-promotion',
        L_THEPLUS_URL . 'modules/widget-promotion/tp-widget-popup.js',
        array(),
        L_THEPLUS_VERSION,
        true
    );

    wp_localize_script(
        'tp-widget-promotion',
        'TP_PROMO_WIDGETS',
        array(
            'widgets' => $tpae_promo_widgets
        )
    );
});
