<?php
/**
 * The file that defines the core plugin class
 *
 * @link       https://posimyth.com/
 * @since      5.6.7
 *
 * @package    the-plus-addons-for-elementor-page-builder
 */

use Elementor\Widgets_Manager;

/**
 * Exit if accessed directly.
 * */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'TP_Widgets_Promotion_Main' ) ) {

	/**
	 * It is Main Class for load all widet feature.
	 *
	 * @since 5.6.7
	 */
	class TP_Widgets_Promotion_Main {

		/**
		 * Member Variable
		 *
		 * @var instance
		 */
		private static $instance;
		

		/**
		 *  Initiator
		 *
		 *  @since 5.6.7
		 */
		public static function get_instance() {
			if ( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}
			return self::$instance;
		}

		/**
		 * Define the core functionality of the plugin.
		 *
		 * @since 5.6.7
		 */
		public function __construct() {
			// $this->tp_get_widgets();

            if ( ! defined( 'THEPLUS_VERSION' ) ) {
				$this->init();
			}
		}

        /**
		 * Initalize integration hooks
		 *
		 * @return void
		 */
		public function init() {
            // $this->promo_widgets = $promo_widgets;

			add_action( 'elementor/widgets/register', array( $this, 'add_widgets' ) );

            add_action( 'elementor/editor/after_enqueue_styles', [ $this, 'enqueue_editor_styles' ] );
			// add_action( 'elementor/editor/after_enqueue_scripts', [ $this, 'enqueue_editor_scripts' ] );
		}

        /**
		 * Add new controls.
		 *
		 * @param  object $widgets_manager Controls manager instance.
		 * @return void
		 */
		public function add_widgets( $widgets_manager ) {

            $tpae_promo_widgets = [
                [
                    'name'       => 'tp-audio-player-adv',
                    'title'      => 'Audio Player (Pro)',
                    'icon'       => 'theplus-i-audio-player',
                    'categories' => [ 'plus-essential' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/audio-player/',
                ],
                [
                    'name'       => 'tp-advanced-typography-adv',
                    'title'      => 'Advanced Typography (Pro)',
                    'icon'       => 'theplus-i-advanced-tpography',
                    'categories' => [ 'plus-essential' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/advanced-typography/',
                ],
                [
                    'name'       => 'tp-advanced-buttons-adv',
                    'title'      => 'Advanced Buttons (Pro)',
                    'icon'       => 'theplus-i-advanced-buttons',
                    'categories' => [ 'plus-creatives' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/advanced-buttons/',
                ],
                [
                    'name'       => 'tp-advertisement-banner-adv',
                    'title'      => 'Advertisement Banner (Pro)',
                    'icon'       => 'theplus-i-advertisement-banner',
                    'categories' => [ 'plus-creatives' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/banner-widget/',
                ],
                [
                    'name'       => 'tp-animated-service-boxes-adv',
                    'title'      => 'Animated Service Boxes (Pro)',
                    'icon'       => 'theplus-i-animated-service-boxes',
                    'categories' => [ 'plus-essential' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/animated-service-boxes/',
                ],
                [
                    'name'       => 'tp-before-after-adv',
                    'title'      => 'Before After (Pro)',
                    'icon'       => 'theplus-i-before-after',
                    'categories' => [ 'plus-creatives' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/before-after-slider/',
                ],
                [
                    'name'       => 'tp-dynamic-smart-showcase-adv',
                    'title'      => 'Dynamic Smart Showcase (Pro)',
                    'icon'       => 'theplus-i-dynamic-smart-showcase',
                    'categories' => [ 'plus-listing' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-listing/#plus-magazine-post-styles/',
                ],
                [
                    'name'       => 'tp-wp-bodymovin-adv',
                    'title'      => 'LottieFiles Animation (Pro)',
                    'icon'       => 'theplus-i-lottiefiles-animation',
                    'categories' => [ 'plus-creatives' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/lottiefiles-animation/',
                ],
                [
                    'name'       => 'tp-carousel-remote-adv',
                    'title'      => 'Carousel Remote (Pro)',
                    'icon'       => 'theplus-i-carousel-remote',
                    'categories' => [ 'plus-creatives' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/carousel-remote-sync/',
                ],
                [
                    'name'       => 'tp-cascading-image-adv',
                    'title'      => 'Image Cascading (Pro)',
                    'icon'       => 'theplus-i-cascading-image',
                    'categories' => [ 'plus-creatives' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/image-cascading/',
                ],
                [
                    'name'       => 'tp-chart-adv',
                    'title'      => 'Chart (Pro)',
                    'icon'       => 'theplus-i-chart',
                    'categories' => [ 'plus-essential' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/pie-chart/',
                ],
                [
                    'name'       => 'tp-circle-menu-adv',
                    'title'      => 'Circle Menu (Pro)',
                    'icon'       => 'theplus-i-circle-menu',
                    'categories' => [ 'plus-creatives' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/circle-menu/',
                ],
                [
                    'name'       => 'tp-coupon-code-adv',
                    'title'      => 'Coupon Code (Pro)',
                    'icon'       => 'theplus-i-coupon-code',
                    'categories' => [ 'plus-essential' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/coupon-code/',
                ],
                [
                    'name'       => 'tp-design-tool-adv',
                    'title'      => 'Design Tool (Pro)',
                    'icon'       => 'theplus-i-design-tool',
                    'categories' => [ 'plus-creatives' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-extras/grid-design-tool/',
                ],
                [
                    'name'       => 'tp-draw-svg-adv',
                    'title'      => 'Draw SVG (Pro)',
                    'icon'       => 'theplus-i-draw-svg',
                    'categories' => [ 'plus-creatives' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/draw-animated-svg-icon/',
                ],
                [
                    'name'       => 'tp-dynamic-listing-adv',
                    'title'      => 'Dynamic Listing (Pro)',
                    'icon'       => 'theplus-i-dynamic-listing',
                    'categories' => [ 'plus-listing' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-listing/dynamic-listing/',
                ],
                [
                    'name'       => 'tp-custom-field-adv',
                    'title'      => 'Custom Field (Pro)',
                    'icon'       => 'theplus-i-tp-custom-field',
                    'categories' => [ 'plus-listing' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/custom-field/',
                ],
                [
                    'name'       => 'tp-dynamic-device-adv',
                    'title'      => 'Dynamic Device (Pro)',
                    'icon'       => 'theplus-i-dynamic-device',
                    'categories' => [ 'plus-creatives' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/dynamic-device-mockups/',
                ],
                [
                    'name'       => 'tp-google-map-adv',
                    'title'      => 'Google Map (Pro)',
                    'icon'       => 'theplus-i-google-map',
                    'categories' => [ 'plus-adapted' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/google-map/',
                ],
                [
                    'name'       => 'tp-hotspot-adv',
                    'title'      => 'Hotspot (Pro)',
                    'icon'       => 'theplus-i-hotspot',
                    'categories' => [ 'plus-creatives' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/hotspot/',
                ],
                [
                    'name'       => 'tp-horizontal-scroll-advance-adv',
                    'title'      => 'Horizontal Scroll (Pro)',
                    'icon'       => 'theplus-i-horizontal-scroll',
                    'categories' => [ 'plus-essential' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/horizontal-scroll/',
                ],
                [
                    'name'       => 'tp-image-factory-adv',
                    'title'      => 'Creative Image (Pro)',
                    'icon'       => 'theplus-i-creative-image',
                    'categories' => [ 'plus-creatives' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/creative-images',
                ],
                [
                    'name'       => 'tp-mailchimp-adv',
                    'title'      => 'MailChimp (Pro)',
                    'icon'       => 'theplus-i-mailchimp',
                    'categories' => [ 'plus-forms' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/mailchimp-form/',
                ],
                [
                    'name'       => 'tp-mobile-menu-adv',
                    'title'      => 'Mobile Menu (Pro)',
                    'icon'       => 'theplus-i-mobile-menu',
                    'categories' => [ 'plus-header' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-builder/header-builder/mobile-menu/',
                ],
                [
                    'name'       => 'tp-morphing-layouts-adv',
                    'title'      => 'Morphing Layouts (Pro)',
                    'icon'       => 'theplus-i-morphing-layouts',
                    'categories' => [ 'plus-creatives' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/morphing-sections',
                ],
                [
                    'name'       => 'tp-mouse-cursor-adv',
                    'title'      => 'Mouse Cursor (Pro)',
                    'icon'       => 'theplus-i-mouse-cursor',
                    'categories' => [ 'plus-creatives' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/mouse-cursor/',
                ],
                [
                    'name'       => 'tp-navigation-menu-adv',
                    'title'      => 'Navigation Menu (Pro)',
                    'icon'       => 'theplus-i-navigation-menu',
                    'categories' => [ 'plus-header' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-builder/header-builder/navigation-menu/',
                ],
                [
                    'name'       => 'tp-off-canvas-adv',
                    'title'      => 'Popup Builder / Off Canvas (Pro)',
                    'icon'       => 'theplus-i-popup-builder-offcanvas',
                    'categories' => [ 'plus-creatives' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/popup-builder/',
                ],
                [
                    'name'       => 'tp-pre-loader-adv',
                    'title'      => 'Pre Loader (Pro)',
                    'icon'       => 'theplus-i-pre-loader',
                    'categories' => [ 'plus-essential' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/preloader-and-page-transition/',
                ],
                [
                    'name'       => 'tp-pricing-list-adv',
                    'title'      => 'Pricing List (Pro)',
                    'icon'       => 'theplus-i-pricing-list',
                    'categories' => [ 'plus-essential' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/price-list/',
                ],
                [
                    'name'       => 'tp-product-listout-adv',
                    'title'      => 'Product Listing (Pro)',
                    'icon'       => 'theplus-i-product-listing',
                    'categories' => [ 'plus-woo-builder' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/product-listout/',
                ],
                [
                    'name'       => 'tp-protected-content-adv',
                    'title'      => 'Protected Content (Pro)',
                    'icon'       => 'theplus-i-protected-content',
                    'categories' => [ 'plus-essential' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/protected-content/',
                ],
                [
                    'name'       => 'tp-row-background-adv',
                    'title'      => 'Row Background (Pro)',
                    'icon'       => 'theplus-i-row-background',
                    'categories' => [ 'plus-creatives' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/section-background/',
                ],
                [
                    'name'       => 'tp-scroll-sequence-adv',
                    'title'      => 'Scroll Sequence (Pro)',
                    'icon'       => 'theplus-i-scroll-sequence',
                    'categories' => [ 'plus-essential' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/image-scroll-sequence/',
                ],
                [
                    'name'       => 'tp-search-filter-adv',
                    'title'      => 'Search Filter (Pro)',
                    'icon'       => 'theplus-i-search-filters',
                    'categories' => [ 'plus-listing' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-builder/woocommerce-builder/ajax-filters',
                ],
                [
                    'name'       => 'tp-search-bar-adv',
                    'title'      => 'Search Bar (Pro)',
                    'icon'       => 'theplus-i-search-bar',
                    'categories' => [ 'plus-listing' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-builder/ajax-search-bar',
                ],
                [
                    'name'       => 'tp-site-logo-adv',
                    'title'      => 'Site Logo (Pro)',
                    'icon'       => 'theplus-i-site-logo',
                    'categories' => [ 'plus-header' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-builder/header-builder/site-logo-for-elementor/',
                ],
                [
                    'name'       => 'tp-shape-divider-adv',
                    'title'      => 'Advanced Separators (Pro)',
                    'icon'       => 'theplus-i-advanced-separators',
                    'categories' => [ 'plus-creatives' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/advanced-separators',
                ],
                [
                    'name'       => 'tp-social-feed-adv',
                    'title'      => 'Social Feed (Pro)',
                    'icon'       => 'theplus-i-social-feed',
                    'categories' => [ 'plus-social' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/combined-filterable-social-feed/',
                ],
                [
                    'name'       => 'tp-social-reviews-adv',
                    'title'      => 'Social Reviews (Pro)',
                    'icon'       => 'theplus-i-social-reviews',
                    'categories' => [ 'plus-social' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/social-reviews-badges/',
                ],
                [
                    'name'       => 'tp-social-sharing-adv',
                    'title'      => 'Social Sharing (Pro)',
                    'icon'       => 'theplus-i-social-sharing',
                    'categories' => [ 'plus-social' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/social-sharing-buttons/',
                ],
                [
                    'name'       => 'tp-table-content-adv',
                    'title'      => 'Table of Content (Pro)',
                    'icon'       => 'theplus-i-table-of-content',
                    'categories' => [ 'plus-essential' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/table-of-contents/',
                ],
                [
                    'name'       => 'tp-timeline-adv',
                    'title'      => 'Timeline (Pro)',
                    'icon'       => 'theplus-i-timeline',
                    'categories' => [ 'plus-creatives' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/timeline/',
                ],
                [
                    'name'       => 'tp-unfold-adv',
                    'title'      => 'Unfold (Pro)',
                    'icon'       => 'theplus-i-unfold',
                    'categories' => [ 'plus-essential' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/unfold/',
                ],
                [
                    'name'       => 'tp-woo-cart-adv',
                    'title'      => 'Woo Cart (Pro)',
                    'icon'       => 'theplus-i-woo-cart',
                    'categories' => [ 'plus-woo-builder' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-builder/woocommerce-builder/#cart/',
                ],
                [
                    'name'       => 'tp-woo-checkout-adv',
                    'title'      => 'Woo Checkout (Pro)',
                    'icon'       => 'theplus-i-woo-checkout',
                    'categories' => [ 'plus-woo-builder' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-builder/woocommerce-builder/#checkout/',
                ],
                [
                    'name'       => 'tp-woo-compare-adv',
                    'title'      => 'Woo Compare (Pro)',
                    'icon'       => 'theplus-i-woo-compare',
                    'categories' => [ 'plus-woo-builder' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/docs/add-product-compare-in-elementor/',
                ],
                [
                    'name'       => 'tp-wp-quickview-adv',
                    'title'      => 'Woo Quickview (Pro)',
                    'icon'       => 'theplus-i-quick-view',
                    'categories' => [ 'plus-woo-builder' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-builder/woocommerce-builder',
                ],
                [
                    'name'       => 'tp-woo-multi-step-adv',
                    'title'      => 'Woo Multi Step (Pro)',
                    'icon'       => 'theplus-i-woo-multi-step',
                    'categories' => [ 'plus-woo-builder' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-builder/woocommerce-builder/',
                ],
                [
                    'name'       => 'tp-woo-myaccount-adv',
                    'title'      => 'Woo My Account (Pro)',
                    'icon'       => 'theplus-i-woo-my-account',
                    'categories' => [ 'plus-woo-builder' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-builder/woocommerce-builder/#my-account/',
                ],
                [
                    'name'       => 'tp-woo-order-track-adv',
                    'title'      => 'Woo Order Track (Pro)',
                    'icon'       => 'theplus-i-woo-order-track',
                    'categories' => [ 'plus-woo-builder' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-builder/woocommerce-builder/#order-track/',
                ],
                [
                    'name'       => 'tp-woo-single-basic-adv',
                    'title'      => 'Woo Single Basic (Pro)',
                    'icon'       => 'theplus-i-woo-single-basic',
                    'categories' => [ 'plus-woo-builder' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-builder/woocommerce-builder/',
                ],
                [
                    'name'       => 'tp-woo-single-image-adv',
                    'title'      => 'Woo Single Image (Pro)',
                    'icon'       => 'theplus-i-woo-product-images',
                    'categories' => [ 'plus-woo-builder' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/woo-single-image/',
                ],
                [
                    'name'       => 'tp-woo-single-pricing-adv',
                    'title'      => 'Woo Single Pricing (Pro)',
                    'icon'       => 'theplus-i-woo-single-pricing',
                    'categories' => [ 'plus-woo-builder' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/woo-single-pricing/',
                ],
                [
                    'name'       => 'tp-woo-single-tabs-adv',
                    'title'      => 'Woo Single Tabs (Pro)',
                    'icon'       => 'theplus-i-woo-single-tabs',
                    'categories' => [ 'plus-woo-builder' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-builder/woocommerce-builder/',
                ],
                [
                    'name'       => 'tp-woo-thank-you-adv',
                    'title'      => 'Woo Thank You (Pro)',
                    'icon'       => 'theplus-i-woo-thank-you',
                    'categories' => [ 'plus-woo-builder' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-builder/woocommerce-builder/',
                ],
                [
                    'name'       => 'tp-woo-wishlist-adv',
                    'title'      => 'Woo Wishlist (Pro)',
                    'icon'       => 'theplus-i-woo-wishlist',
                    'categories' => [ 'plus-woo-builder' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-builder/woocommerce-builder/',
                ],
                [
                    'name'       => 'tp-wp-login-register-adv',
                    'title'      => 'WP Login Register (Pro)',
                    'icon'       => 'theplus-i-wp-login-register',
                    'categories' => [ 'plus-essential' ],
                    'promo_url'  => 'https://theplusaddons.com/pricing/',
                    'demo_url'  => 'https://theplusaddons.com/elementor-widget/login-form/',
                ],
            ];

            if ( ! defined( 'THEPLUS_VERSION' ) ) {
				include L_THEPLUS_PATH . 'modules/widget-promotion/tp-widget-popup.php';

				foreach ( $tpae_promo_widgets as $tpae_promo ) {
					$widgets_manager->register( new \TheplusAddons\Widgets\TPAE_Widget_Promotion( $tpae_promo ) );
				}

                // foreach ( $tpae_promo_widgets as $promo ) {
                //     $widgets_manager->register_widget_type( new \TheplusAddons\Widgets\Widget_Promotion( $promo ) );
                // }
			}
        }

		public function enqueue_editor_styles() {
			wp_enqueue_style(
				'tp-widget-promotion',
				L_THEPLUS_URL . 'modules/widget-promotion/tp-widget-popup.css',
				[],
				L_THEPLUS_VERSION
			);
		}

	}

	return TP_Widgets_Promotion_Main::get_instance();
}